#!/bin/bash
# Check if script is running as root first
if [[ "$(whoami)" != "root" ]]; then
  echo "$(tput setaf 1)Script must be ran as root! Example: sudo ./ubuntu-gui-prep.sh$(tput sgr 0)"
  exit 1
fi


cloud-init clean
dpkg-reconfigure cloud-init 
apt purge cloud-init -y
rm -rf /etc/cloud/ 
rm -rf /var/lib/cloud/
mv /etc/netplan/00-installer-config.yaml /etc/netplan/01-netcfg.yaml
(cat <<EOF 
#Comment (#) out 'dhcp4: yes' and uncomment all lines below for Manual IP Config
#Run 'sudo netplan apply' to apply changes
network:
  version: 2
  ethernets:
    ens192:
      dhcp4: yes
#      dhcp4: no
#      addresses:
#        - 192.168.0.10/24
#      gateway4: 192.168.0.1
#      nameservers:
#          addresses: [8.8.8.8, 8.8.4.4]
EOF
) > /etc/netplan/01-netcfg.yaml
(cat <<EOF
blacklist {
  device {
    vendor "VMware"
    product "Virtual disk"
  }
}
EOF
) | sudo tee -a /etc/multipath.conf
apt update
apt upgrade -y
apt install firewalld net-tools dnsutils open-vm-tools htop iotop -y
apt autoremove -y
apt clean
truncate -s0 /etc/resolv.conf
truncate -s0 /etc/machine-id
rm /var/lib/dbus/machine-id
ln -s /etc/machine-id /var/lib/dbus/machine-id
echo 'ubuntu ALL=(ALL) NOPASSWD:ALL' >> /etc/sudoers
passwd --expire ubuntu
rm ./ubuntu-prep.sh
truncate -s0 ~/.bash_history
truncate -s0 /home/ubuntu/.bash_history
shutdown -h now
