#!/bin/bash
# Check if script is running as root first
if [[ "$(whoami)" != "root" ]]; then
  echo "$(tput setaf 1)Script must be ran as root! Example: sudo ./ubuntu-gui-prep.sh$(tput sgr 0)"
  exit 1
fi

apt update
apt upgrade -y
apt install xubuntu-core^ mugshot open-vm-tools-desktop firefox geany -y
apt list --installed | cut -d/ -f1 | grep -E 'pulse|libappindicator|xfce4-indicator|wpasupplicant' >> apps.txt
apt autoremove $(cat apps.txt) -y
apt purge $(cat apps.txt) -y
rm apps.txt

(cat <<EOF
<?xml version="1.0" encoding="UTF-8"?>

<channel name="xfce4-panel" version="1.0">
  <property name="panels" type="uint" value="1">
    <property name="panel-0" type="empty">
      <property name="position" type="string" value="p=6;x=0;y=0"/>
      <property name="length" type="uint" value="100"/>
      <property name="position-locked" type="bool" value="true"/>
      <property name="plugin-ids" type="array">
        <value type="int" value="1"/>
        <value type="int" value="2"/>
        <value type="int" value="3"/>
        <value type="int" value="4"/>
        <value type="int" value="5"/>
        <value type="int" value="6"/>
        <value type="int" value="7"/>
        <value type="int" value="8"/>
      </property>
      <property name="background-style" type="uint" value="0"/>
      <property name="size" type="uint" value="24"/>
      <property name="length-adjust" type="bool" value="true"/>
      <property name="span-monitors" type="bool" value="false"/>
      <property name="mode" type="uint" value="0"/>
      <property name="autohide-behavior" type="uint" value="0"/>
    </property>
  </property>
  <property name="plugins" type="empty">
    <property name="plugin-1" type="string" value="whiskermenu"/>
    <property name="plugin-2" type="string" value="tasklist">
      <property name="grouping" type="uint" value="1"/>
    </property>
    <property name="plugin-3" type="string" value="separator">
      <property name="style" type="uint" value="0"/>
      <property name="expand" type="bool" value="true"/>
    </property>
    <property name="plugin-4" type="string" value="separator">
      <property name="style" type="uint" value="0"/>
    </property>
    <property name="plugin-5" type="string" value="notification-plugin"/>
    <property name="plugin-6" type="string" value="statusnotifier"/>
    <property name="plugin-7" type="string" value="separator">
      <property name="style" type="uint" value="0"/>
    </property>
    <property name="plugin-8" type="string" value="clock">
      <property name="digital-format" type="string" value="%d %b, %H:%M"/>
    </property>
  </property>
</channel>
EOF
) >/etc/xdg/xdg-xubuntu/xfce4/panel/default.xml



rm ./gui-ubuntu-prep.sh
reboot