#!/bin/bash
# Check if script is running as root first
if [[ "$(whoami)" != "root" ]]; then
  echo "$(tput setaf 1)Script must be ran as root!  Example: sudo ./gui-debian-prep.sh$(tput sgr 0)"
  exit 1
fi

apt update
apt upgrade -y
apt install xfce4 xfce4-terminal xfce4-whiskermenu-plugin xfce4-power-manager xfce4-statusnotifier-plugin greybird-gtk-theme open-vm-tools-desktop mugshot firefox-esr geany -y
apt autoremove ncurses-term pulseaudio -y
apt purge pulseaudio -y
sed -i 's/workspace_count=4/workspace_count=1/g' /usr/share/xfwm4/defaults
sed -i 's/property name="ThemeName" type="string" value="Xfce"/property name="ThemeName" type="string" value="Greybird"/g' /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xsettings.xml
sed -i 's/#greeter-hide-users=false/greeter-hide-users=false/g' /etc/lightdm/lightdm.conf
sed -i 's/#indicators=/indicators=~host;~spacer;~session;~language;~ally;~clock;~power;/g' /etc/lightdm/lightdm-gtk-greeter.conf
sed -i 's/#clock-format=/clock-format=%d %b, %H:%M/g' /etc/lightdm/lightdm-gtk-greeter.conf
rm /usr/share/xsessions/lightdm-xsession.desktop

(cat <<EOF
<?xml version="1.0" encoding="UTF-8"?>

<channel name="xfce4-panel" version="1.0">
  <property name="configver" type="int" value="2"/>
  <property name="panels" type="array">
    <value type="int" value="1"/>
    <property name="dark-mode" type="bool" value="true"/>
    <property name="panel-1" type="empty">
      <property name="position" type="string" value="p=6;x=0;y=0"/>
      <property name="length" type="uint" value="100"/>
      <property name="position-locked" type="bool" value="true"/>
      <property name="icon-size" type="uint" value="16"/>
      <property name="size" type="uint" value="26"/>
      <property name="plugin-ids" type="array">
        <value type="int" value="1"/>
        <value type="int" value="2"/>
        <value type="int" value="3"/>
        <value type="int" value="4"/>
        <value type="int" value="5"/>
        <value type="int" value="6"/>
        <value type="int" value="7"/>
        <value type="int" value="8"/>
      </property>
    </property>
  </property>
  <property name="plugins" type="empty">
    <property name="plugin-1" type="string" value="whiskermenu"/>
    <property name="plugin-2" type="string" value="tasklist">
      <property name="grouping" type="uint" value="1"/>
    </property>
    <property name="plugin-3" type="string" value="separator">
      <property name="expand" type="bool" value="true"/>
      <property name="style" type="uint" value="0"/>
    </property>
    <property name="plugin-4" type="string" value="separator">
      <property name="style" type="uint" value="0"/>
    </property>
    <property name="plugin-5" type="string" value="notification-plugin"/>
    <property name="plugin-6" type="string" value="statusnotifier"/>
    <property name="plugin-7" type="string" value="separator">
      <property name="style" type="uint" value="0"/>
    </property>
    <property name="plugin-8" type="string" value="clock">
      <property name="digital-format" type="string" value="%d %b, %R"/>
    </property>
  </property>
</channel>
EOF
) >/etc/xdg/xfce4/panel/default.xml
rm ./gui-debian-prep.sh
reboot