#!/bin/bash
# Check if script is running as root first
if [[ "$(whoami)" != "root" ]]; then
  echo "$(tput setaf 1)Script must be ran as root!  Example: sudo ./debian-prep.sh$(tput sgr 0)"
  exit 1
fi


(cat <<EOF 
# This file describes the network interfaces available on your system
# and how to activate them. For more information, see interfaces(5).

source /etc/network/interfaces.d/*

# The loopback network interface
auto lo
iface lo inet loopback

# The primary network interface
allow-hotplug ens192
iface ens192 inet dhcp
#auto ens192
#iface ens192 inet static
#  address 192.168.1.2
#  netmask 255.255.255.0
#  gateway 192.168.1.1
#  dns.domain corp.local
#  dns-nameservers 8.8.8.8 8.8.4.4
EOF
) > /etc/network/interfaces
apt update
apt upgrade -y
apt install firewalld net-tools curl dnsutils resolvconf open-vm-tools htop iotop -y
apt autoremove -y
apt clean
truncate -s0 /etc/machine-id
truncate -s0 /etc/resolv.conf
rm /var/lib/dbus/machine-id
ln -s /etc/machine-id /var/lib/dbus/machine-id
echo 'debian ALL=(ALL) NOPASSWD:ALL' >> /etc/sudoers
passwd --expire debian
rm ./debian-prep.sh
truncate -s0 ~/.bash_history
truncate -s0 /home/debian/.bash_history
shutdown -h now